minetest server inside of Docker container
===
## this repo based on colorlandia game, you need to do adjustments to almost all files in this repo to make it actually work
tested on minetest 5.10.0 and debian 12
[list of hardcoded pathes](hardcoded-pathes.md)
obtaining minetest files
### basic server setup
login as root, then create a users for minetest and for another stuff, and set passwords
```bash
useradd -mG sudo user -s /bin/bash
passwd user
passwd root
useradd -m minetest -s /bin/bash
passwd minetest
```
set the timezone
```bash
sudo dpkg-reconfigure tzdata
```
update the system and install some required packages
```bash
apt update
apt upgrade
apt install sudo ufw tmux htop mc needrestart docker.io dbus-user-session slirp4netns uidmap rootlesskit wget inotify-tools docker-compose sqlite3 time
apt clean
```
setup an SSH, copy id to your server, on the host machine do:
```bash
ssh-copy-id username@host
```
then on the server disable password SSH login, in file `/etc/ssh/sshd_config` set 
```conf
PasswordAuthentication no
```
disable system wide docker and create symbolic links to docker rootless scripts, somewhy they are located in really unusual place in debian
```bash
systemctl disable --now containerd.service docker.service docker.socket
for f in /usr/share/docker.io/contrib/*; do sudo ln -s $f /usr/bin; done
```
login as minetest and then install dockerd-rootless
```bash
dockerd-rootless-setuptool.sh check
dockerd-rootless-setuptool.sh install
```
setup a swap file
```bash
fallocate -l 512M /swapfile
chmod 0600 /swapfile
mkswap -U clear /swapfile
swapon /swapfile
echo "/swapfile none swap defaults 0 0" | sudo tee -a /etc/fstab
```
setup a firewall
```bash
ufw allow 30000/udp
ufw allow OpenSSH
ufw enable
```
firstly clone a minetest git repo
```bash
git clone https://github.com/minetest/minetest.git
cd minetest
```
optionally switch to stable branch
```bash
git switch stable-5
```
apply the patch, basically to bump the alpine version
```bash
patch -p1 < $PATH_TO_THIS_REPO/minetest-docker/Dockerfile.patch
```
create required dirs
```bash
mkdir -p ~/minetest-colorlandia-world/{data/.minetest,conf}
mkdir ~/minetest-colorlandia-world/data/.minetest/{games,mods,worlds}
```
`minetest.conf` are located at `~/minetest-colorlandia-world/conf/minetest.conf`
game data are located in `~/minetest-colorlandia-world/data/.minetest`, subdirs are:
* `games/` - games are located here, like devtest, minetest, nodecore, colorlandia
* `mods/` - mods for games, such as areas, xban2
* `worlds/` - actual worlds
* `debug.txt` - game log
-----
## build the container locally
```bash
cp $PATH_TO_THIS_REPO/minetest-docker/compose.yaml compose.yaml
DOCKER_BUILDKIT=1 docker-compose up --no-start --build
```
## build image locally and then transfer it to the server [UNTESTED]
save the image
```bash
docker image save minetest_minetest_colorlandia_server | zstd -z -T$(nproc) -15 > ~/minetest_minetest_colorlandia_server.tar.zstd
```
transfer it to the server as you usually do. <br>
to load it:
```bash
zstdcat ~/minetest_minetest_colorlandia_server.tar.zstd | docker image load 
```
use compose-localimage.yaml instead of compose.yaml
```bash
cp $PATH_TO_THIS_REPO/minetest-docker/compose-localimage.yaml compose.yaml
DOCKER_BUILDKIT=1 docker-compose up --no-start --build
```
---
---
## main configuration
copy a `minetest.conf.sample` to conf directory
```bash
cp $PATH_TO_THIS_REPO/minetest.conf.sample ~/minetest-colorlandia-world/conf
```
this file is only an example, adjust it as needed
---
## world preparation
* first of all you're need to select mods you're want to use
  * mods that i use can be found at [colorlandia/mods.txt](colorlandia/mods.txt)
* find a cool mapgen and seed you're want to use
  * for colorlandia i use `flat` mapgen with seed `15592485853830570708`
* build basic map:
  * spawn
  * roads
  * infrastructure
  * some basic builds
* set some config for mods
* protect the spawn
  * just create areas.dat file

areas.dat:
```json
[{"name":"spawn freedom","owner":"admin","pos1":{"x":-24.0,"y":-64.0,"z":-24.0},"pos2":{"x":24.0,"y":24.0,"z":24.0}},{"name":"spawn","owner":"admin","pos1":{"x":-24.0,"y":-128.0,"z":-19.0},"pos2":{"x":40.0,"y":-94.0,"z":26.0}}]
```

copy these files from your world:
* env_meta.txt
* map.sqlite
* map_meta.txt
* optionally mod_storage.sqlite
if you copy `mod_storage.sqlite`, check it to have actuall info
also add a [LICENSE](colorlandia/WORLD_LICENSE.md)

copy your game into `~/minetest-colorlandia-world/data/.minetest/games` and your mods into `~/minetest-colorlandia-world/data/.minetest/mods`

create world.mt, looks like that for me:
```ini
enable_damage = false
creative_mode = true
gameid = colorlandia
world_name = colorlandia
mod_storage_backend = sqlite3
auth_backend = sqlite3
player_backend = sqlite3
backend = sqlite3
load_mod_areas = mods/areas
load_mod_autotrek = mods/autotrek
load_mod_boards = mods/display_modpack/boards
load_mod_chatlog = mods/chatlog
load_mod_dcwebhook = mods/dcwebhook
load_mod_display_api = mods/display_modpack/display_api
load_mod_emoji = mods/emoji
load_mod_font_api = mods/display_modpack/font_api
load_mod_font_metro = mods/display_modpack/font_metro
load_mod_inspector = mods/inspector
load_mod_itemframes = mods/itemframes
load_mod_mail = mods/mail
load_mod_newplayer = mods/newplayer
load_mod_notice = mods/notice
load_mod_playertracker = mods/playertracker
load_mod_reboot_warner = mods/reboot_warner
load_mod_replacer = mods/replacer
load_mod_sethome = mods/sethome
load_mod_signs = mods/display_modpack/signs
load_mod_signs_api = mods/display_modpack/signs_api
load_mod_signs_road = mods/display_modpack/signs_road
load_mod_skinsdb = mods/skinsdb
load_mod_steles = mods/display_modpack/steles
load_mod_szutil_chatsounds = mods/szutilpack/szutil_chatsounds
load_mod_szutil_fixhack = mods/szutilpack/szutil_fixhack
load_mod_szutil_idlekick = mods/szutilpack/szutil_idlekick
load_mod_szutil_motd = mods/szutilpack/szutil_motd
load_mod_szutil_pruneplayers = mods/szutilpack/szutil_pruneplayers
load_mod_tpr = mods/tpr
load_mod_travelnet = mods/travelnet
load_mod_unified_inventory = mods/unified_inventory_cl
load_mod_worldedit = mods/worldedit/worldedit
load_mod_worldedit_brush = mods/worldedit/worldedit_brush
load_mod_worldedit_commands = mods/worldedit/worldedit_commands
load_mod_worldedit_gui = mods/worldedit/worldedit_gui
load_mod_worldedit_shortcommands = mods/worldedit/worldedit_shortcommands
load_mod_xban2 = mods/xban2
load_mod_xcompat = mods/xcompat
```

specified for colorlandia i do some changes:
* i used version of `sfinv` from `minetest_game`
* version of [unified_inventory_cl](https://github.com/dibesfer/unified_inventory_cl) from dibesfer
* [removed](colorlandia/welcome.lua.patch) welcome screen
* added [rules](colorlandia/rules.txt) to `$worldpath/szutil_motd.txt`
* added [skins](colorlandia/default%20skins/README.md) to skinsdb
* removed other skins
not specified for colorlandia:
* [changed](colorlandia/reboot_warner.patch) interval and message for [reboot_warner](https://github.com/mt-mods/reboot_warner)

## system preparation
you need to allow docker user to write into data dir, so
```bash
chmod -R o+w ~/minetest-colorlandia-world/data/.minetest/
```
make sure user serveices stay running after loging out
```bash
loginctl enable-linger minetest
```
start the docker service
```bash
docker start minetest-colorlandia
```
---
# setting up a backup script
copy [backup script](backup-script) to `~/backup-script-colorlandia`
then cd into it, create destination, build a container
```bash
> /home/minetest/.cache/minetest-colorlandia.copied
cd ~/backup-script-colorlandia
mkdir ~/minetest-colorlandia-world/backup
chmod o+w ~/minetest-colorlandia-world/backup/
DOCKER_BUILDKIT=1 docker-compose up --no-start --build
```
setup a systemd timer
```bash
cp minetest-backup-colorlandia.* ~/.config/systemd/user/
systemctl --user daemon-reload
systemctl --user list-unit-files
systemctl --user enable --now minetest-backup-colorlandia.timer
```

# maintenance
## it's actually possible to enter namespace of docker container
```bash
rootlesskit bash
```
## backups can be compressed
```bash
tar c backup/ | time zstd -z -17 -T2 > backup-<date>.tar.zst
```